$PROB Phase IIa Study, One Compartment Model 504f.ctl
$INPUT C ID TIME DV AMT RATE WT AGE SEX 
$DATA 501.csv IGNORE=C ; Ignore records beginning with letter C
; Select One compartment model ADVAN1, Parameterization TRANS2 (CL, V)
$SUBROUTINE ADVAN1 TRANS2 
; Section to define PK parameters, relationship to fixed effects THETA
; and inter-subject random effects ETA.
$PK 
; Define typical values
  TVCL=THETA(1)*(WT/70)**THETA(3)*(AGE/50)**THETA(5)*THETA(7)**SEX
  TVV= THETA(2)*(WT/70)**THETA(4)*(AGE/50)**THETA(6)*THETA(8)**SEX
  CL=TVCL*EXP(ETA(1))
  V=TVV*EXP(ETA(2))
  S1=V

$THETA ; Enter initial starting values for THETAS
  (0.0,4)            ;[CL]
  (0.0,30)            ;[V]
  (0.75 FIXED)   ;[CL~WT]
  (1.0 FIXED)    ;[V~WT]
  -0.1           ;[CL~AGE]
  (0.0 FIXED)    ;[V~AGE]
  (1.0 FIXED)    ;[CL~SEX]
  (1.0 FIXED)    ;[V~SEX]

; Section to relate predicted function F and residual error
; relationship to data DV.  EPS are random error coefficients
$ERROR 
  Y=F*(1+EPS(1))
$OMEGA BLOCK(2) ; Initial OMEGA values in lower triangular format
  0.1         ;[P]
  0.001 0.1   ;[P]
$SIGMA ; Initial SIGMA
  0.04        ;[P]

$EST METHOD=COND INTERACTION MAXEVAL=9999 PRINT=5 NOABORT 
$COV UNCONDITIONAL MATRIX=R PRINT=E
; Print out individual predicted results diagnostics
; to file 504.tab
$TABLE ID TIME DV CIPRED CIRES CIWRES PRED RES CWRES CL V ETA1 ETA2
       NOPRINT NOAPPEND ONEHEADER FORMAT=,1PE13.6 FILE=504f.tab

